	function PLOT_PHASE_Z(wT, Phase, minPhase, maxPhase)
	
	% Plots the phase response for an IIR filter.
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2005-05-07
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:	 
	% Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================	
	hold on;
	plot(wT, Phase,'linewidth', lw);	
	N = length(Phase);
	Diff = Phase(1:N-1) - Phase(2:N);
	Index = find(abs(Diff) > 6.25);
	% Remove plot of vertial lines from -pi to pi which are artifacts
	for i = 1:length(Index)		
		plot([wT(Index(i)) wT(Index(i))],[Phase(Index(i)), Phase(Index(i)+1)], 'w', 'linewidth', lw+1);
	end

	% Correct plot for the phase discontinuities at single zeros on the unit circle
	Diff = Phase(1:N-1) - Phase(2:N);
	Index = find((Phase(1:N-1) > Phase(2:N) + 3.13));
	for i = 1:length(Index)		
		plot([wT(Index(i)) wT(Index(i))],[Phase(Index(i)), Phase(Index(i)+1)], 'w', 'linewidth', lw);
		plot([wT(Index(i)) wT(Index(i))],[Phase(Index(i)), pi], 'k', 'linewidth', lw);
		plot([wT(Index(i)) wT(Index(i))],[-pi, Phase(Index(i)+1)], 'k', 'linewidth', lw);
	end
	axis([0 max(wT) minPhase maxPhase]);
	ylabel('{\it\Phi}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);
	%	ylabel('{\it\Delta\it\Phi}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);
	xlabel('{\it\omegaT}  [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);

	%	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	%	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	
	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
	xtick(ax,lab);	
	ay = [-pi -0.75*pi -0.5*pi -0.25*pi 0 0.25*pi 0.5*pi 0.75*pi pi];
	%	laby = {'-\pi';'-0.75\pi';'-0.5\pi';' ';' ';' ';'0.5\pi';'0.75\pi';'\pi'};
	laby = {'-\pi';'-0.75\pi';' ';' ';' ';' ';' ';'0.75\pi';'\pi'};
	
	%	ay = [0 0.1*pi   0.4*pi 0.5*pi ];
	%	laby = {' ';'0.1\pi';'0.4\pi';'0.5\pi'};
	
	ytick(ay,laby); 
	grid on;
	box on;
		
